<?php
include "db.php";

$selected_bien_ban = [];
$ordered_rows = [];
$tong_to = 100;
$tu_to = 1;
$den_to = $tong_to;

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST["bien_ban_list"])) {
    $input = $_POST["bien_ban_list"];
    $selected_bien_ban = array_filter(array_map("trim", explode(",", $input)), function($bb) {
        return preg_match("/^[A-Za-z0-9\-\/\.]+$/", $bb);
    });

    if (!empty($selected_bien_ban)) {
        $placeholders = implode(",", array_fill(0, count($selected_bien_ban), "?"));
        $sql = "SELECT ngay_vi_pham, so_bien_ban, bien_kiem_soat, ho_ten_nvp 
                FROM bien_ban_vi_pham 
                WHERE so_bien_ban IN ($placeholders)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(str_repeat("s", count($selected_bien_ban)), ...$selected_bien_ban);
        $stmt->execute();
        $result = $stmt->get_result();

        $rows = [];
        while ($row = $result->fetch_assoc()) {
            $row["ngay"] = date("d/m/Y", strtotime($row["ngay_vi_pham"]));
            $rows[$row['so_bien_ban']][] = $row;
        }

        $need_date_selection = false;
        foreach ($selected_bien_ban as $bb) {
            if (!empty($rows[$bb])) {
                $dates = array_unique(array_column($rows[$bb], "ngay"));
                if (count($dates) > 1 && empty($_POST["loc_toan_bo"])) {
                    $need_date_selection = true;
                } else {
                    $ngay_chon = $_POST["ngay_chon_$bb"] ?? $dates[0];
                    foreach ($rows[$bb] as $r) {
                        if ($r["ngay"] == $ngay_chon) {
                            $ordered_rows[] = $r;
                        }
                    }
                }
            }
        }

        // Nếu có biên bản trùng nhiều ngày → hiển thị form chọn ngày cụ thể
        if ($need_date_selection) {
            echo "<form method='POST'>";
            echo "<input type='hidden' name='bien_ban_list' value='" . htmlspecialchars($input) . "'>";
            foreach ($selected_bien_ban as $bb) {
                if (!empty($rows[$bb])) {
                    $dates = array_unique(array_column($rows[$bb], "ngay"));
                    if (count($dates) > 1) {
                        echo "<label style='color:red;'>Chọn_</label>";
                        echo "<label style='color:Black;'>ngày cho Số Biên Bản_____</label>";
                        echo "<label style='color:Blue;'>: $bb</label>";
                        echo "<select name='ngay_chon_$bb'>";
                        foreach ($dates as $d) {
                            echo "<option value='$d'>$d</option>";
                        }
                        echo "</select><br><br>";
                    }
                }
            }
            echo "<button type='submit' name='loc_toan_bo' value='1'>Lọc Toàn Bộ</button>";
            echo "</form>";
        }
    }
}

include "template.html";

if (!empty($ordered_rows)) {
    echo "<button id='print-button' onclick='window.print()'>In bảng thống kê</button>";
    echo "<table><thead><tr>
            <th rowspan='2'>Số TT</th>
            <th colspan='4'>TRÍCH YẾU TÀI LIỆU</th>
            <th rowspan='2'>Từ Tờ Đến Tờ</th>
            <th rowspan='2'>Ghi chú</th>
            <th rowspan='2' class='action-column'>Thao tác</th>
          </tr>
          <tr>
            <th>Ngày VP</th><th>Số BB</th><th>Biển số</th><th>Người VP</th>
          </tr></thead><tbody>";

    $stt = 1;
    $so_dong = count($ordered_rows);
    $so_to_moi_dong = ceil($tong_to / $so_dong);
    $to_bat_dau = $tu_to;

    foreach ($ordered_rows as $row) {
        $to_ket_thuc = min($to_bat_dau + $so_to_moi_dong - 1, $den_to);
        echo "<tr>
                <td>" . str_pad($stt, 2, "0", STR_PAD_LEFT) . "</td>
                <td>" . htmlspecialchars($row["ngay"]) . "</td>
                <td>" . htmlspecialchars($row["so_bien_ban"]) . "</td>
                <td>" . htmlspecialchars($row["bien_kiem_soat"]) . "</td>
                <td>" . htmlspecialchars($row["ho_ten_nvp"]) . "</td>
                <td>
                    <input type='number' class='tu-to' value='$to_bat_dau'>–
                    <input type='number' class='den-to' value='$to_ket_thuc'>
                </td>
                <td><input type='text-medium' name='ghi_chu_$stt' size='5' placeholder='.....'></td>
                <td class='action-column'><button type='button' class='delete-row'>Xóa</button></td>
              </tr>";
        $to_bat_dau = $to_ket_thuc + 1;
        $stt++;
    }
    
    echo "</tbody></table>";

    // JS xử lý nút Xóa và tự động tăng "Từ Tờ"
    echo "<script>
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('delete-row')) {
            e.target.closest('tr').remove();
        }
    });

    document.addEventListener('input', function(e) {
        if (e.target.classList.contains('den-to')) {
            let denTo = parseInt(e.target.value, 10);
            let nextRow = e.target.closest('tr').nextElementSibling;
            if (nextRow) {
                let tuToInput = nextRow.querySelector('.tu-to');
                if (tuToInput) {
                    tuToInput.value = denTo + 1;
                }
            }
        }
    });
    </script>";
} elseif ($_SERVER["REQUEST_METHOD"] === "POST") {
    echo "<p>Không tìm thấy biên bản nào phù hợp</p>";
}
?>