document.addEventListener("DOMContentLoaded", function () {
    const tableBody = document.querySelector("table tbody");
    if (!tableBody) return;

    tableBody.addEventListener("click", function (e) {
        if (e.target.classList.contains("delete-row")) {
            const row = e.target.closest("tr");
            if (confirm("Bạn có chắc chắn muốn xóa dòng này?")) {
                row.remove();
                updateSTT();
            }
        }
    });

    function updateSTT() {
        const rows = tableBody.querySelectorAll("tr");
        rows.forEach((row, index) => {
            const sttCell = row.querySelector("td:first-child");
            if (sttCell) {
                sttCell.textContent = String(index + 1).padStart(2, "0");
            }
        });
    }
});