<?php
$host = "localhost";
$username = "root";
$password = "";
$database = "dongnai";

$conn = new mysqli($host, $username, $password, $database);
if ($conn->connect_error) {
    die("Kết nối thất bại: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

$selected_bien_ban = [];
$ordered_rows = [];
$tong_to = 290;
$tu_to = 1;
$den_to = $tong_to;

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($_POST["bien_ban_list"])) {
    $input = $_POST["bien_ban_list"];
    $selected_bien_ban = array_filter(array_map("trim", explode(",", $input)), function($bb) {
    return preg_match("/^[A-Za-z0-9\-\/\.]+$/", $bb);
});

    if (!empty($selected_bien_ban)) {
        $placeholders = implode(",", array_fill(0, count($selected_bien_ban), "?"));
        $sql = "SELECT ngay_vi_pham, so_bien_ban, bien_kiem_soat, ho_ten_nvp 
                FROM bien_ban_vi_pham 
                WHERE so_bien_ban IN ($placeholders)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(str_repeat("s", count($selected_bien_ban)), ...$selected_bien_ban);
        $stmt->execute();
        $result = $stmt->get_result();

        $rows = [];
        while ($row = $result->fetch_assoc()) {
            $rows[$row['so_bien_ban']] = $row;
        }

        foreach ($selected_bien_ban as $bb) {
            if (isset($rows[$bb])) {
                $ordered_rows[] = $rows[$bb];
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Lọc biên bản vi phạm</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 10px; }
        .form-container { margin-bottom: 12px; }
		
		
        input[type="text"] { width: 100%; padding: 6px; margin-bottom: 8px; }
		input[type="text1"] { width: 5%; padding: 2px; margin-bottom: 2px; }
		
		
		
        input[type="number"] { width: 40px; padding: 2px; font-size: 11px; }
        input[type="submit"] { padding: 6px 12px; }
        table { border-collapse: collapse; width: 100%; text-align: center; font-size: 12px; }
        th, td { border: 1px solid #333; padding: 4px; line-height: 1.2; }
        th { background-color: #f2f2f2; }
        .title { text-align: center; font-weight: bold; margin-bottom: 8px; }
        button.delete-row { padding: 2px 6px; font-size: 11px; background-color: #f44336; color: white; border: none; cursor: pointer; }
        button.delete-row:hover { background-color: #d32f2f; }
        #print-button { margin-bottom: 10px; padding: 6px 12px; font-size: 12px; }
		
		
		.header { font-size: 6px; text-align: right; }
		
		
		
		

        @media print {
            .form-container,
            .delete-row,
            .action-column,
            #print-button {
                display: none !important;
            }
        }
		
		/* Lề in 15mm bên trái */
        @page {
            margin-left: 18mm;
        }
		
		
		
		
		
    </style>
	
	
	
	
	
	
	
	
	
	
	
</head>
<body>



<div class='header'>
        Mẫu B3<br>
        Ban hành kèm theo TT số:44/2025/BCA<br>
        ngày 18/6/2025
    </div>








<div class="form-container">
    <form method="POST">
        <label>Danh sách số biên bản (cách nhau bằng dấu phẩy):</label><br>
        <input type="text" name="bien_ban_list" placeholder="VD: BB001,BB002" required value="<?php echo htmlspecialchars($_POST['bien_ban_list'] ?? ''); ?>"><br>
        <input type="submit" value="Lọc biên bản">
    </form>
</div>

<?php if (!empty($ordered_rows)): ?>
    <button id="print-button" onclick="window.print()">In bảng thống kê</button>

    <div class="title">
        <br>Thống Kê Tài Liệu Có Trong Hồ Sơ </br>
        Số Hồ Sơ : 116XL0925/713CM </br>
		Tập:<input type="text1" >-Số <input type="text1" >/713CM.Khung:<input type="text1" >  </br>
		        
		
    </div>

    <form method="POST">
        <table>
            <thead>
                <tr>
                    <th rowspan="2">Số TT</th>
                    <th colspan="4">TRÍCH YẾU TÀI LIỆU</th>
                    <th rowspan="2">Từ Tờ Đến Tờ</th>
                    <th rowspan="2">Ghi chú</th>
                    <th rowspan="2" class="action-column">Thao tác</th>
                </tr>
                <tr>
                    <th>Ngày VP</th>
                    <th>Số BB</th>
                    <th>Biển số</th>
                    <th>Người VP</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $stt = 1;
                $so_dong = count($ordered_rows);
                $so_to_moi_dong = ceil($tong_to / $so_dong);
                $to_bat_dau = $tu_to;

                foreach ($ordered_rows as $row) {
                    $to_ket_thuc = min($to_bat_dau + $so_to_moi_dong - 1, $den_to);

                    echo "<tr>";
                    echo "<td>" . str_pad($stt, 2, "0", STR_PAD_LEFT) . "</td>";
                    echo "<td>" . date("d/m/Y", strtotime($row["ngay_vi_pham"])) . "</td>";
                    echo "<td>" . htmlspecialchars($row["so_bien_ban"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["bien_kiem_soat"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["ho_ten_nvp"]) . "</td>";
                    echo "<td style='white-space: nowrap;'>
                            <input type='number' name='tu_to_row[$stt]' value='$to_bat_dau'>–
                            <input type='number' name='den_to_row[$stt]' value='$to_ket_thuc'>
                          </td>";
                    echo "<td></td>";
                    echo "<td class='action-column'><button type='button' class='delete-row'>Xóa</button></td>";
                    echo "</tr>";

                    $to_bat_dau = $to_ket_thuc + 1;
                    $stt++;
                }
                ?>
            </tbody>
        </table>
    </form>
<?php elseif ($_SERVER["REQUEST_METHOD"] === "POST"): ?>
    <p>Không tìm thấy biên bản nào phù hợp</p>
<?php endif; ?>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const tableBody = document.querySelector("table tbody");

    tableBody.addEventListener("click", function (e) {
        if (e.target.classList.contains("delete-row")) {
            const row = e.target.closest("tr");
            if (confirm("Bạn có chắc chắn muốn xóa dòng này?")) {
                row.remove();
                updateSTT();
            }
        }
    });

    function updateSTT() {
        const rows = tableBody.querySelectorAll("tr");
        rows.forEach((row, index) => {
            const sttCell = row.querySelector("td:first-child");
            if (sttCell) {
                sttCell.textContent = String(index + 1).padStart(2, "0");
            }
        });
    }
});
</script>

</body>
</html>